<?php

namespace VM\NotesBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * UserNote
 *
 * @ORM\Table(name="usernotes_quantity")
 * @ORM\Entity()
 */
class UserNotesQuantity
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_id", type="integer")
     */
    private $user_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="notes_quantity", type="integer", nullable=true)
     */
    private $notes_quantity;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user_id
     *
     * @param integer $userId
     * @return UserNotesQuantity
     */
    public function setUserId($userId)
    {
        $this->user_id = $userId;
    
        return $this;
    }

    /**
     * Get user_id
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Set notes_quantity
     *
     * @param integer $notesQuantity
     * @return UserNotesQuantity
     */
    public function setNotesQuantity($notesQuantity)
    {
        $this->notes_quantity = $notesQuantity;
    
        return $this;
    }

    /**
     * Get notes_quantity
     *
     * @return integer 
     */
    public function getNotesQuantity()
    {
        return $this->notes_quantity;
    }
}